/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

import frc.emul.util.Utils;
import java.io.IOException;
import java.util.HashMap;

public class OverlayShaderUtils {
    static final boolean DEBUG = true;
    static final boolean LOAD_SOURCES = true;
    public static final String UNIFORM_TX_OVERLAY_OPAQUE = "txOp";
    public static final String UNIFORM_TX_OVERLAY_TRANSP = "txTr";
    public static final String UNIFORM_TX_BACKBUFFER = "txBB";
    private static final String SOURCE_FS = "data/shader-sources/overlay.fragment";
    private static final String SOURCE_VS = "data/shader-sources/overlay.vertex";
    private static final HashMap<String, Long> sourceTags = new HashMap();

    public static final StringBuilder generateFragmentShader(Params params) {
        return OverlayShaderUtils.loadSource(SOURCE_FS, "<TMIN>", Float.valueOf(params.lowThreshold), "<TMAX>", Float.valueOf(params.highThreshold), "<FMIN>", Float.valueOf(params.minLightFactor), "<FMAX>", Float.valueOf(params.maxLightFactor));
    }

    public static final StringBuilder generateVertexShader() {
        return OverlayShaderUtils.loadSource(SOURCE_VS);
    }

    public static final boolean sourceChanged() {
        return OverlayShaderUtils.sourceChanged(SOURCE_VS) || OverlayShaderUtils.sourceChanged(SOURCE_FS);
    }

    private static final Long fetchSourceTag(String string) {
        try {
            return Utils.getFile(string).lastModified();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static final boolean sourceChanged(String string) {
        Long l = OverlayShaderUtils.fetchSourceTag(string);
        if (!l.equals(sourceTags.get(string))) {
            sourceTags.put(string, l);
            return true;
        }
        return false;
    }

    private static final StringBuilder loadSource(String string, Object ... objectArray) {
        StringBuilder stringBuilder = OverlayShaderUtils.loadSource(string);
        String string2 = Utils.substitute(stringBuilder.toString(), objectArray);
        return new StringBuilder(string2);
    }

    private static final StringBuilder loadSource(String string) {
        byte[] byArray;
        try {
            byArray = Utils.loadResource(string);
            OverlayShaderUtils.sourceChanged(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load source [" + string + "]", iOException);
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            stringBuilder.append((char)byArray[n++]);
        }
        return stringBuilder;
    }

    public static void main(String[] stringArray) {
        StringBuilder stringBuilder = OverlayShaderUtils.generateVertexShader();
        StringBuilder stringBuilder2 = OverlayShaderUtils.generateFragmentShader(new Params());
        System.out.println("_____________________________________________________________");
        System.out.println(stringBuilder);
        System.out.println("_____________________________________________________________");
        System.out.println(stringBuilder2);
        System.out.println("_____________________________________________________________");
    }

    public static class Params {
        public float minLightFactor = 0.4f;
        public float maxLightFactor = 1.0f;
        public float lowThreshold = 0.02f;
        public float highThreshold = 0.5f;
        public boolean flipTxOpaque = true;
        public boolean flipTxTransp = true;
    }
}

